<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * Company.
 *
 * Structure class for relation brand.company.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class Company extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.company')
            ->setPrimaryKey(['id'])
            ->addField('id', 'int8')
            ->addField('gid', 'public.global_id')
            ->addField('description', 'text')
            ->addField('name', 'text')
            ->addField('id_country', 'int8')
            ->addField('id_image', 'int8')
            ->addField('created_at', 'timestamp')
            ->addField('updated_at', 'timestamp')
            ->addField('data', 'brand.company.data')
            ->addField('tags', 'public.tag3d_array')
            ->addField('alt', 'jsonb')
            ;
    }
}
