<?php

namespace Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Transportation;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Place extends ConstrainedObject
{
    const LINE_COLLECTION = LineCollection::class;

    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'stop' => null,
            'lines' => null
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'lines' => new ClassDefinition([
                'class' => self::LINE_COLLECTION,
                'nullable' => true
            ]),
        ];
    }
}
