<?php

namespace Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Transportation;

use Allocine\DbzModelBundle\Internal\Type\Generic\Coordinates;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Line extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'label' => null,
            'distance' => null,
            'coordinates' => null,
            'style' => null
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'coordinates' => new ClassDefinition([
                'class' => Coordinates::class
            ]),
            'style' => new ClassDefinition([
                'class' => LineStyle::class
            ]),
        ];
    }
}
