<?php

namespace Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property string $email
 * @property string $phone
 * @property string $movie_line
 * @property string $url
 * @property string $url_showtimes
 * @property string $url_showtimes_alternate
 * @property string $url_android
 * @property string $url_ios
 * @property string $url_acceslibre
 * @property string $note
 * @property TemporaryClosure $temporary_closure
 * @property NextOpening $next_opening
 */
class Info extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'email' => null,
            'phone' => null,
            'movie_line' => null,
            'url' => null,
            'url_showtimes' => null,
            'url_showtimes_alternate' => null,
            'url_android' => null,
            'url_ios' => null,
            'url_acceslibre' => null,
            'note' => null,
            'temporary_closure' => null,
            'next_opening' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'temporary_closure' => new ClassDefinition([
                'class' => TemporaryClosure::class,
                'nullable' => true,
            ]),
            'next_opening' => new ClassDefinition([
                'class' => NextOpening::class,
                'nullable' => true,
            ]),
        ];
    }
}
