<?php

$finder = (new PhpCsFixer\Finder())
    ->in(__DIR__ . '/src')
    ->in(__DIR__ . '/tests')
    ->append([__FILE__])
;

return (new PhpCsFixer\Config())
    ->setRules([
        '@PSR1' => true,
        '@PSR2' => true,
        '@Symfony' => true,
        '@Symfony:risky' => true,
        'concat_space' => [
            'spacing' => 'one',
        ],
        'array_syntax' => ['syntax' => 'short'],
        'compact_nullable_type_declaration' => true,
        'doctrine_annotation_spaces' => true,
        'doctrine_annotation_indentation' => true,
        'doctrine_annotation_braces' => true,
        'logical_operators' => true,
        'no_superfluous_phpdoc_tags' => true,
        'ordered_imports' => true,
        'ordered_class_elements' => true,
        'yoda_style' => false,
    ])
    ->setRiskyAllowed(true)
    ->setFinder($finder)
;
