<?php

namespace Allocine\DbzModelBundle\Tests\Model;

use Allocine\DbzModelBundle\Model\Movie\MovieModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class MasterSlaveTest extends KernelTestCase
{
    /**
     * Check if a slave model use the slave session and the master model the master one.
     */
    public function testSlaveModel()
    {
        $kernel = static::bootKernel();

        /** @var MovieModel $slaveModel */
        $slaveModel = $kernel->getContainer()->get('test.service_using_slave_model')[0];
        $this->assertSame('dbz.slave_1', $slaveModel->getSession()->getStamp());

        /** @var MovieModel $masterModel */
        $slaveModel = $kernel->getContainer()->get('test.testable_services')[0];
        $this->assertSame('dbz', $slaveModel->getSession()->getStamp());
    }
}
