<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use Allocine\DbzModelBundle\Model\Secure\AutoStructure\Token as TokenStructure;

/**
 * Model for the Token entity.
 */
class TokenModel extends Model
{
    use WriteQueries;

    public function __construct()
    {
        $this->structure = new TokenStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Secure\Token';
    }

    /**
     * @param array $fields
     *
     * @return Projection
     */
    public function createProjection(array $fields = [])
    {
        if (empty($fields)) {
            return parent::createProjection();
        }

        $projection = parent::createProjection();
        foreach ($fields as $name => $field) {
            $projection->setField($name, ...$field);
        }
    }

    /**
     * @param array  $fields
     * @param string $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|Token[]
     */
    public function findAll(array $fields = [], string $suffix = '')
    {
        $sql = strtr(
            "select {projection} from {relation} $suffix",
            [
                '{projection}' => $this->createProjection($fields),
                '{relation}' => $this->structure->getRelation(),
            ]
        );

        return $this->query($sql);
    }

    /**
     * Returns a Token by its uuid.
     *
     * @param string $uuid
     *
     * @return Token|null
     */
    public function findByUuid(string $uuid)
    {
        $iterator = $this
            ->findWhere('uuid = $*', [$uuid])
        ;

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * Returns a Token by its raw string.
     *
     * @param string $token
     *
     * @return Token|null
     */
    public function findByToken(string $token)
    {
        $iterator = $this
            ->findWhere('token = $*', [$token])
        ;

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * Returns a Token for a given gid_user.
     *
     * @param string      $userId
     * @param string|null $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|Token[]
     */
    public function findByUserId(string $userId, string $suffix = null)
    {
        $iterator = $this->findWhere('gid_user = $*', [$userId], $suffix);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }
}
