<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use PommProject\ModelManager\Model\FlexibleEntity;

class Application extends FlexibleEntity
{
    /**
     * Returns true if the application has access to a specific schema.
     *
     * @param string $name
     *
     * @return bool
     */
    public function hasAccessToSchema(string $name): bool
    {
        return isset($this->container['config']['schemas']) ? in_array($name, $this->config['schemas']) : false;
    }

    /**
     * Returns an array of available schemas for this application.
     *
     * @return array
     */
    public function availableSchemas(): array
    {
        return isset($this->container['config']['schemas']) ? array_unique($this->config['schemas']) : [];
    }

    public function isActive()
    {
        return $this->get('active') === true;
    }
}
