<?php

namespace Allocine\DbzModelBundle\Model\Movie;

use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Movie\AutoStructure\MovieLocalized as MovieLocalizedStructure;
use Allocine\DbzModelBundle\Model\Movie\MovieLocalized;

/**
 * MovieLocalizedModel
 *
 * Model class for table movie_localized.
 *
 * @see Model
 */
class MovieLocalizedModel extends Model
{
    use WriteQueries;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new MovieLocalizedStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Movie\MovieLocalized';
    }
}
