<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use Allocine\DbzModelBundle\Domains\GlobalId as GlobalIdDomain;
use PommProject\Foundation\Converter\ArrayTypeConverter;
use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;

class GlobalId extends ArrayTypeConverter
{
    /**
     * fromPg
     *
     * @see ConverterInterface
     */
    public function fromPg($data, $type, Session $session)
    {
        $data = trim($data);

        if ($data === '') {
            return null;
        }

        $explodedData = explode('.', $data);

        if (count($explodedData) != 4) {
            throw new \RuntimeException(sprintf(
                'Invalid globalIg [%s]',
                $data
            ));
        }

        return new GlobalIdDomain($explodedData[0], $explodedData[1], $explodedData[2], $explodedData[3]);
    }

    /**
     * toPg
     *
     * @see ConverterInterface
     */
    public function toPg($data, $type, Session $session)
    {
        $data = $this->convertDataToString($data);

        return
            $data !== null
                ? sprintf("ltree '%s'", $data)
                : sprintf("NULL::%s", $type)
            ;
    }

    /**
     * toPgStandardFormat
     *
     * @see ConverterInterface
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return $this->convertDataToString($data);
    }

    /**
     * @param $data
     *
     * @return string
     *
     * @throws \PommProject\Foundation\Exception\ConverterException
     */
    private function convertDataToString($data)
    {
        if (null === $data) {
            return $data;
        } elseif ($data instanceof GlobalIdDomain || is_string($data)) {
            return (string) $data;
        } else {
            return implode('.', $this->checkArray($data));
        }
    }
}
