<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class SlaveModelPass implements CompilerPassInterface
{
    /**
     * Registers slave models to the slave session.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function process(ContainerBuilder $container)
    {
        $servicesIds = $container->findTaggedServiceIds(ModelPass::SERVICE_PREFIX.'.replicated');

        $backends = $container->getExtensionConfig('dbz_model')[0]['backends'];
        $slaveSessionServiceId = ModelPass::SESSION_SERVICE_PREFIX.'.'.ServiceHelper::findSessionNameByType($backends, ServiceHelper::BACKEND_SLAVE);

        foreach ($servicesIds as $id => $tags) {
            $masterModelDefinition = $container->getDefinition($id);

            $alias = ServiceHelper::generateAliasForModel(
                $id,
                ModelPass::SERVICE_PREFIX,
                'slave'
            );

            $class = $masterModelDefinition->getClass();

            $slaveDefinition = (clone $masterModelDefinition);
            $tags = $slaveDefinition->getTags();
            $tags['pomm.model'][0] = [
                'pooler' => 'dbz.pooler.model.slave',
                'session' => $slaveSessionServiceId,
            ];
            $slaveDefinition->setTags($tags);
            $container->setDefinition($alias, $slaveDefinition);

            // This part should not be required because it should be registerd by the Pomm ModelPass, but it does not
            // work for a reason.
            $container->register($alias, $class)
                ->setFactory([new Reference($slaveSessionServiceId), 'getModel'])
                ->addArgument($class)
            ;

            $container->getDefinition('Allocine\DbzModelBundle\Internal\Core\ModelRegistry')
                ->addMethodCall('set', [$class, ['master_service_id' => $id, 'slave_service_id' => $alias]]);
        }
    }
}
