<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserModelTest extends KernelTestCase
{
    /**
     * @var UserModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserModel::class);
    }

    public function testLoadByIdLegacy()
    {
        $this->assertEquals(
            $this->model->findByPK([
                'id_brand' => 'AC',
                'id' => 2000000000
            ]),
            $this->model->loadByIdLegacy('Z00000000000000000000000')
        );

        $this->assertEquals(
            $this->model->findByPK([
                'id_brand' => 'AC',
                'id' => 2000000001
            ]),
            $this->model->loadByIdLegacy('Z00000000000000000000001')
        );

        $this->assertNull(
            $this->model->loadByIdLegacy('Z00000000000000000000002')
        );
    }

    /**
     * Test if a user can be deleted
     */
    public function testCanDelete()
    {
        // User 1 can be deleted (no dependancies)

        $user1 = $this->model->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000000
        ]);

        $this->assertTrue($this->model->canDelete($user1));

        // User 2 can't be deleted (1 rating)

        $user2 = $this->model->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000001
        ]);

        $this->assertFalse($this->model->canDelete($user2));
    }

    /**
     * Test if a user can be anonymized
     */
    public function testDeleteOrAnonymize()
    {
        // Deletable user

        $deletableUser = $this->model->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000000
        ]);

        $this->model->deleteOrAnonymize($deletableUser);

        $this->assertNull(
            $this->model->findByPK([
                'id_brand' => 'AC',
                'id' => 2000000000
            ])
        );

        // Non-deletable user

        $nonDeletableUser = $this->model->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000001
        ]);

        $this->model->deleteOrAnonymize($nonDeletableUser);

        $anonymizedUser = $this->model->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000001
        ]);

        foreach ([
            'nickname' => null,
            'profile' => [],
            'email' => null,
            'active' => false,
            'password' => null,
            'salt' => null,
            'alt' => [],
        ] as $key => $value) {
            $this->assertEquals($value, $anonymizedUser->{$key});
        }
    }

    public function testLoadByGid(): void
    {
        //given
        $idActiveUser = 'social.user.AC.1';
        $idInactiveUser = 'social.user.AC.2';

        //when & then
        static::assertNotNull($this->model->loadByGid($idActiveUser));
        static::assertNotNull($this->model->loadByGid($idInactiveUser));
        static::assertNotNull($this->model->loadByActiveGid($idActiveUser));
        static::assertNull($this->model->loadByActiveGid($idInactiveUser));
    }
}
