<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserHasTheaterModel;
use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Model\Theater\Theater;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserHasTheaterModelTest extends KernelTestCase
{
    /**
     * @var UserHasTheaterModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserHasTheaterModel::class)
        ;
    }

    /**
     *
     */
    public function testFindAllTheatersByUser()
    {
        $user1 = $this->getSession()->getModel(UserModel::class)->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000000
        ]);

        $theaters1 = $this->model->findAllTheatersByUser($user1);

        $this->assertEquals(
            [ 1, 2, 3, 4 ],
            array_keys($theaters1->getArrayCopy())
        );

        $this->assertEquals(
            Theater::class,
            get_class($theaters1->offsetGet(1))
        );

        $this->assertEquals(
            [ 'D0001', 'D0002', 'D0003', 'D0004' ],
            array_values(array_map(
                function ($t) {return $t->code;},
                $theaters1->getArrayCopy()
            ))
        );

        $user2 = $this->getSession()->getModel(UserModel::class)->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000001
        ]);

        $theaters2 = $this->model->findAllTheatersByUser($user2);

        $this->assertEquals(
            [ 1, 2, 3 ],
            array_keys($theaters2->getArrayCopy())
        );

        $this->assertEquals(
            [ 'D0004', 'D0003', 'D0001' ],
            array_values(array_map(
                function ($t) {return $t->code;},
                $theaters2->getArrayCopy()
            ))
        );
    }

    /**
     *
     */
    public function testRemoveTheaterForUser()
    {
        $user = $this->getSession()->getModel(UserModel::class)->findByPK([
            'id_brand' => 'AC',
            'id' => 2000000000
        ]);

        $theaters = $this->model->findAllTheatersByUser($user);

        $this->assertEquals(
            [ 1, 2, 3, 4 ],
            array_keys($theaters->getArrayCopy())
        );

        $this->assertEquals(
            [ 'D0001', 'D0002', 'D0003', 'D0004' ],
            array_values(array_map(
                function ($t) {return $t->code;},
                $theaters->getArrayCopy()
            ))
        );

        // remove _0003

        $removed = $this->model->removeTheaterForUser('D0003', $user);

        $this->assertEquals('D0003', $removed->code_theater);

        $theaters = $this->model->findAllTheatersByUser($user);

        $this->assertEquals(
            [ 1, 2, 3 ],
            array_keys($theaters->getArrayCopy())
        );

        $this->assertEquals(
            [ 'D0001', 'D0002', 'D0004' ],
            array_values(array_map(
                function ($t) {return $t->code;},
                $theaters->getArrayCopy()
            ))
        );

        // remove _0001

        $removed = $this->model->removeTheaterForUser('D0001', $user);

        $this->assertEquals('D0001', $removed->code_theater);

        $theaters = $this->model->findAllTheatersByUser($user);

        $this->assertEquals(
            [ 1, 2 ],
            array_keys($theaters->getArrayCopy())
        );

        $this->assertEquals(
            [ 'D0002', 'D0004' ],
            array_values(array_map(
                function ($t) {return $t->code;},
                $theaters->getArrayCopy()
            ))
        );

        // remove _0004

        $removed = $this->model->removeTheaterForUser('D0004', $user);

        $this->assertEquals('D0004', $removed->code_theater);

        $theaters = $this->model->findAllTheatersByUser($user);

        $this->assertEquals(
            [ 1 ],
            array_keys($theaters->getArrayCopy())
        );

        $this->assertEquals(
            [ 'D0002' ],
            array_values(array_map(
                function ($t) {return $t->code;},
                $theaters->getArrayCopy()
            ))
        );

        // remove _0002

        $removed = $this->model->removeTheaterForUser('D0002', $user);

        $this->assertEquals('D0002', $removed->code_theater);

        $theaters = $this->model->findAllTheatersByUser($user);

        $this->assertEquals([],$theaters->getArrayCopy());

        // remove _0005

        $removed = $this->model->removeTheaterForUser('D0002', $user);

        $this->assertNull($removed->code_theater);

        $theaters = $this->model->findAllTheatersByUser($user);

        $this->assertEquals([],$theaters->getArrayCopy());
    }

    /**
     *
     */
    public function testCountByUser()
    {
        $expected = [
            2000000000 => 4,
            2000000001 => 3,
            2000000002 => 0,
        ];

        foreach ($expected as $idUser => $expectedCount) {
            $user = $this->getSession()->getModel(UserModel::class)->findByPK([
                'id_brand' => 'AC',
                'id' => $idUser
            ]);

            $this->assertEquals(
                $expectedCount,
                $this->model->countByUser($user)
            );
        }
    }

}
