<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserHasRatingReviewModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserHasRatingReviewModelTest extends KernelTestCase
{
    /**
     * @var UserHasRatingReviewModel
     */
    private $model;

    /**
     * Setup before
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->model = $this
            ->getSession()
            ->getModel(UserHasRatingReviewModel::class)
        ;
    }

    /**
     *
     */
    public function testGetByEntity()
    {
        // Ratings

        $expected = [
            'movie.movie._.2000000000' => 2,
            'movie.movie._.2000000001' => 2,
            'movie.movie._.2000000002' => 2,
            'movie.movie._.2000000003' => 1,
        ];

        foreach ($expected as $gidEntity => $expectedCount) {
            $results = $this->model->getBrandedModel('AC')->findWhere(
                'gid_entity = $*',
                [ $gidEntity ]
            );

            $this->assertEquals($expectedCount, $results->count());
        }

        // Ratings with review

        $expected = [
            'movie.movie._.2000000000' => 2,
            'movie.movie._.2000000001' => 2,
            'movie.movie._.2000000002' => 1,
            'movie.movie._.2000000003' => 0,
        ];

        foreach ($expected as $gidEntity => $expectedCount) {
            $results = $this->model->getBrandedModel('AC')->findWhere(
                'gid_entity = $* AND has_linked_review',
                [ $gidEntity ]
            );

            $this->assertEquals($expectedCount, $results->count());
        }

        // Ratings with no review

        $expected = [
            'movie.movie._.2000000000' => 0,
            'movie.movie._.2000000001' => 0,
            'movie.movie._.2000000002' => 1,
            'movie.movie._.2000000003' => 1,
        ];

        foreach ($expected as $gidEntity => $expectedCount) {
            $results = $this->model->getBrandedModel('AC')->findWhere(
                'gid_entity = $* AND NOT has_linked_review',
                [ $gidEntity ]
            );

            $this->assertEquals($expectedCount, $results->count());
        }

    }

}
