<?php

namespace Allocine\DbzModelBundle\Tests\Domain;

use Allocine\DbzModelBundle\Domains\GlobalId;

class GlobalIdTest extends \PHPUnit\Framework\TestCase
{
    public function testConstruct()
    {
        // Basic titania construct from array

        $gid = new GlobalId([
            'schema' => 'A',
            'table' => 'B',
            'brand' => 'AC',
            'id' => '1',
        ]);

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);

        // Basic titania construct from object

        $gid = new GlobalId((object)[
            'schema' => 'A',
            'table' => 'B',
            'brand' => 'AC',
            'id' => '1',
        ]);

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);

        // Basic titania construct from json string

        $gid = new GlobalId('{
            "schema": "A",
            "table": "B",
            "brand": "AC",
            "id": "1"
        }');

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);

        // Tag from pg string representation

        $gid = new GlobalId('A.B.AC.1');

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);

        // Tag from pomm array representation

        $gid = new GlobalId(['A', 'B', 'AC', '1']);

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);

        // Tag from old GlobalId constructor

        $gid = new GlobalId('A', 'B', 'AC', '1');

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);

        // Tag from json basic array, just in case

        $gid = new GlobalId('[ "A", "B", "AC", 1]');

        $this->assertEquals('A', $gid->schema);
        $this->assertEquals('B', $gid->table);
        $this->assertEquals('AC', $gid->brand);
        $this->assertEquals('1', $gid->id);
    }

    public function testInvalidConstruct()
    {
        // Invalid data

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid $data for Allocine\DbzModelBundle\Domains\GlobalId constructor'
        );

        new GlobalId(2);
    }

    public function testToString()
    {
        $gid = new GlobalId('A', 'B', 'AC', '1');

        $this->assertEquals('A.B.AC.1', $gid->__toString());
    }

    public function testToLtreeString()
    {
        $gid = new GlobalId('A', 'B', 'AC', '1');

        $this->assertEquals([ 'A', 'B', 'AC', '1' ], $gid->toLtreeArray());
    }

    public function testSetAttribute()
    {
        $gid = new GlobalId();

        $gid->brand = '_';

        $this->assertEquals('_', $gid->brand);

        $gid->brand = 'AC';

        $this->assertEquals('AC', $gid->brand);

        // Wrong brand data

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid brand value [coin] for Allocine\DbzModelBundle\Domains\GlobalId'
        );

        $gid->brand = 'coin';
    }

}
