<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandTheaterDay as BrandTheaterDayStructure;

/**
 * BrandTheaterDayModel
 *
 * Model class for table brand_theater_day.
 *
 * @see Model
 */
class BrandTheaterDayModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandTheaterDayStructure;
        $this->flexible_entity_class = BrandTheaterDay::class;
    }
}
