<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandMovieVideoDay as BrandMovieVideoDayStructure;

/**
 * BrandMovieVideoDayModel
 *
 * Model class for table brand_movie_video_day.
 *
 * @see Model
 */
class BrandMovieVideoDayModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandMovieVideoDayStructure;
        $this->flexible_entity_class = BrandMovieVideoDay::class;
    }
}
