<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserHasRating as UserHasRatingStructure;
use PommProject\ModelManager\Model\Model;

/**
 * UserHasRatingModel.
 *
 * Model class for table user_has_rating.
 *
 * @see Model
 */
class UserHasRatingModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const LEGACY_SAFE = true;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserHasRatingStructure();
        $this->flexible_entity_class = UserHasRating::class;
    }

    /**
     * @param int $userId
     * @param string $brandId
     * @param string $entityGid
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator
     */
    public function findByUserAndEntityWithReview(int $userId, string $brandId, string $entityGid)
    {
        $reviewModel = $this
            ->getSession()
            ->getModel('Allocine\DbzModelBundle\Model\Social\UserHasReviewModel')
        ;

        $where = Where::create('ra.id_user = $* AND ra.id_brand = $* AND ra.gid_entity = $*', [$userId, $brandId, $entityGid]);

        $projection = $this->createProjection()
            ->setField('review_body', 're.body', 'boolean')
            ->setField('review_status', 're.status', 'tag3d')
        ;

        $sql = "
            SELECT {projection}
            FROM {relation} ra
            LEFT JOIN {review} re ON (ra.id=re.id) AND (ra.id_brand=re.id_brand)
            WHERE {where}
        ";

        $sql = strtr(
            $sql,
            [
                '{projection}' => $projection->formatFields('ra'),
                '{relation}' => $this->structure->getRelation(),
                '{review}' => $reviewModel->getStructure()->getRelation(),
                '{where}' => $where,
            ]
        );

        return $this->query($sql, $where->getValues());
    }

    /**
     * @param User $user
     * @return int
     */
    public function countByUser(User $user) : int
    {
        return $this->countWhere(
            'id_user = $* AND id_brand = $*',
            [
                'id_user' => $user->id,
                'id_brand' => $user->id_brand,
            ]
        );
    }
}
