<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Tag as TagStructure;

/**
 * TagModel
 *
 * Model class for table tag.
 *
 * @see Model
 */
class TagModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const TAG_SCOPE_AGE = 'AGE';
    const TAG_SCOPE_PROVIDER = 'PROVIDER';
    const TAG_SCOPE_THEME = 'THEME';

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new TagStructure;
        $this->flexible_entity_class = Tag::class;
    }
}
