<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Image as ImageStructure;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * ImageModel.
 *
 * Model class for table image.
 *
 * @see Model
 */
class ImageModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new ImageStructure();
        $this->flexible_entity_class = Image::class;
    }
}
