<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\FestivalCompetition as FestivalCompetitionStructure;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * FestivalCompetitionModel
 *
 * Model class for table festival_competition.
 *
 * @see Model
 */
class FestivalCompetitionModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new FestivalCompetitionStructure;
        $this->flexible_entity_class = FestivalCompetition::class;
    }
}
