<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;

use Allocine\DbzModelBundle\Model\Brand\AutoStructure\CarouselItem as CarouselItemStructure;

/**
 * CarouselItemModel
 *
 * Model class for table carousel_item.
 *
 * @see Model
 */
class CarouselItemModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new CarouselItemStructure;
        $this->flexible_entity_class = CarouselItem::class;
    }
}
