<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Brand as BrandStructure;
use PommProject\ModelManager\Model\CollectionIterator;
use PommProject\ModelManager\Model\Model;

/**
 * BrandModel.
 *
 * Model class for table brand.
 *
 * @see Model
 */
class BrandModel extends ElementModel
{
    use ModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new BrandStructure();
        $this->flexible_entity_class = Brand::class;
    }

    /**
     * @param null|string $id
     * @param bool|null $active
     * @return CollectionIterator
     */
    public function getBrandsWithCountryReleaseDay(
        ?string $id = null,
        ?bool $active = true
    ) : CollectionIterator {

        $sql = <<<SQL
SELECT
  brand.*,
  country.data->>'showtime_week_release_day' AS showtime_week_release_day
FROM brand.brand
INNER JOIN executive.country
  ON brand.id_country = country.id
WHERE brand.active = $*
:additionnal_where
SQL;

        $values = [ $active ];

        if (is_null($id)) {
            $sql = str_replace(
                ':additionnal_where',
                '',
                $sql
            );
        } else {
            $sql = str_replace(
                ':additionnal_where',
                'AND brand.id = $*',
                $sql
            );
            $values[] = $id;
        }

        $projection = $this
            ->createProjection()
            ->setField(
                'showtime_week_release_day',
                'showtime_week_release_day',
                'text'
            );

        return $this->query($sql, $values, $projection);
    }
}
