<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\User;

use Allocine\DbzModelBundle\Internal\Type\Social\User\Data\BadgeCollection;
use Allocine\DbzModelBundle\Internal\Type\Social\User\Data\Token;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class Data
 * @package Allocine\DbzModelBundle\Internal\Type\Social\User
 *
 * @property Token activation
 * @property Token password_reset
 * @property BadgeCollection badges
 */
class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'activation' => null,
            'password_reset' => null,
            'badges' => []
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'activation' => new ClassDefinition([
                'class' => Token::class,
                'nullable' => true
            ]),
            'password_reset' => new ClassDefinition([
                'class' => Token::class,
                'nullable' => true
            ]),
            'badges' => new ClassDefinition([
                'class' => BadgeCollection::class
            ])
        ];
    }
}
