<?php

namespace Allocine\DbzModelBundle\Internal\Type\Generic\Office;

use Allocine\Titania\Type\Base\ObjectCollection;

class OfficeCollection extends ObjectCollection
{
    protected $internalObjectClass = Office::class;

    /**
     * @return array
     */
    public function getExistingDepartmentNames() : array
    {
        $ret = [];

        foreach ($this as $office) {
            foreach ($office->departments as $department) {
                if (! array_key_exists($department->name, $ret)) {
                    $ret[$department->name] = true;
                }
            }
        }

        return array_keys($ret);
    }
}
