<?php

namespace Allocine\DbzModelBundle\Internal\Core;

use Allocine\DbzModelBundle\Internal\Converter\Company\OfficeCollection;
use Allocine\DbzModelBundle\Internal\Converter\DataWithSeo;
use Allocine\DbzModelBundle\Internal\Converter\GlobalId;
use Allocine\DbzModelBundle\Internal\Converter\GlobalIdArray;
use Allocine\DbzModelBundle\Internal\Converter\Link;
use Allocine\DbzModelBundle\Internal\Converter\Origin;
use Allocine\DbzModelBundle\Internal\Converter\Social\UserHasRating\CertificationStatusEnum;
use Allocine\DbzModelBundle\Internal\Converter\Tag3D;
use Allocine\DbzModelBundle\Internal\Converter\Tag3DArray;
use Allocine\DbzModelBundle\Internal\Converter\Geometry;
use Allocine\DbzModelBundle\Internal\Converter\Address;
use Allocine\DbzModelBundle\Internal\Converter\Company\Data as CompanyData;
use Allocine\DbzModelBundle\Internal\Converter\Executive\Locale\Data
    as ExecutiveLocaleData;
use Allocine\DbzModelBundle\Internal\Converter\Product\Data as ProductData;
use Allocine\DbzModelBundle\Internal\Converter\Theater\Data as TheaterData;
use Allocine\DbzModelBundle\Internal\Converter\Screen\Data as ScreenData;
use Allocine\DbzModelBundle\Internal\Converter\Secure\Token\Data as SecureTokenData;
use Allocine\DbzModelBundle\Internal\Converter\Social\User\Data as SocialUserData;
use Allocine\DbzModelBundle\Internal\Converter\DarkZone\Lost\MatchingData
    as DarkZoneLostMatchingData;
use Allocine\DbzModelBundle\Internal\Converter\Social\UserHasReview\Data
    as SocialUserHasReviewData;
use Allocine\DbzModelBundle\Internal\Converter\Social\UserHasReview\Stats
    as SocialUserHasReviewStats;
use Allocine\DbzModelBundle\Internal\Converter\Social\UserHasRatingReview\Data
    as SocialUserHasRatingReviewData;
use Allocine\DbzModelBundle\Internal\Converter\Theater\Transportation;
use Allocine\DbzModelBundle\Internal\Converter\TsTzRangeArray;
use Allocine\DbzModelBundle\Internal\Converter\Brand\Tag\Data as TagData;
use Allocine\DbzModelBundle\Internal\Converter\Brand\Author\Data as AuthorData;
use Allocine\DbzModelBundle\Internal\Converter\Brand\Company\Data
    as BrandCompanyData;
use Allocine\DbzModelBundle\Internal\Converter\Brand\EntityFlag\Flag;
use Allocine\DbzModelBundle\Internal\Converter\Brand\EntityHasOverride\Data
    as EntityHasOverrideData;
use Allocine\DbzModelBundle\Internal\Converter\Brand\BrandHasMovie\Data
    as BrandHasMovieData;
use Allocine\DbzModelBundle\Internal\Converter\Brand\BrandHasPerson\Data
    as BrandHasPersonData;
use Allocine\DbzModelBundle\Internal\Converter\Brand\Theater\Data
    as BrandTheaterData;
use Allocine\DbzModelBundle\Internal\Converter\EmptyData;
use Allocine\DbzModelBundle\Internal\Converter\Movie\MovieHasRelease\Data
    as MovieMovieHasReleaseData;
use Allocine\DbzModelBundle\Internal\Converter\Series\SeriesHasRelease\Data
    as SeriesSeriesHasReleaseData;
use Allocine\DbzModelBundle\Internal\Converter\Series\SeriesSeasonHasRelease\Data
    as SeriesSeriesSeasonHasReleaseData;
use Allocine\DbzModelBundle\Internal\Converter\Series\SeriesEpisodeHasRelease\Data
    as SeriesSeriesEpisodeHasReleaseData;
use PommProject\Foundation\Converter\PgString;
use PommProject\Foundation\Converter\PgTsRange;
use PommProject\Foundation\Session\Session;
use PommProject\Foundation\Converter\ConverterHolder;
use PommProject\Foundation\Converter\PgLtree;
use PommProject\ModelManager\SessionBuilder as ModelManagerSessionBuilder;
use Psr\Log\LoggerInterface;
use PommProject\SymfonyBridge\DatabaseDataCollector;

class SessionBuilder extends ModelManagerSessionBuilder
{
    /**
     * @var DatabaseDataCollector
     */
    protected $datacollector;

    public function setDatacollector(DatabaseDataCollector $datacollector)
    {
        $this->datacollector = $datacollector;
    }

    /**
     * @param Session|\PommProject\Foundation\Session $session
     *
     * @return Session|SessionBuilder
     *
     * @throws \PommProject\Foundation\Exception\FoundationException
     */
    protected function postConfigure(Session $session)
    {
        parent::postConfigure($session);

        $session
            ->getClientUsingPooler('listener', 'query')
            ->attachAction(function($eventName, $data, Session $session) {
                $logger = $session->getLogger();
                if ($logger instanceof LoggerInterface) {
                    $logger->debug($eventName, $data);
                }

                $this->datacollector->execute($eventName, $data, $session);
            })
        ;

        $session
            ->getPoolerForType('converter')
            ->getConverterHolder()
            ->addTypeToConverter('Origin', 'tool.origin')
            ->addTypeToConverter('Origin', 'origin')
            ->addTypeToConverter('String', 'public.partial_date')
            ->addTypeToConverter('Tag3D', 'public.tag3d')
            ->addTypeToConverter('Tag3DArray', 'public.tag3d_array')
            ->addTypeToConverter('GlobalId', 'public.global_id')
            ->addTypeToConverter('GlobalIdArray', 'public.global_id_array')
            ->addTypeToConverter('LTtree', 'public.ltree')
            ->addTypeToConverter('Link', 'public.link')
            ->addTypeToConverter('Geometry', 'public.geometry')
            ->addTypeToConverter('Address', 'generic.address')
            ->addTypeToConverter('TsTzRange', 'tstzrange')
            ->addTypeToConverter('TsTzRangeArray', 'tstzrange_array')
            ->addTypeToConverter('OfficeCollection', 'generic.office_collection')
            ->addTypeToConverter('DataWithSeo', 'generic.data_with_seo')
            ->addTypeToConverter('CertificationStatusEnum', 'social.cert_status_enum')
        ;

        return $this;
    }

    /**
     * @see SessionBuilder
     */
    protected function initializeConverterHolder(ConverterHolder $converter_holder)
    {
        parent::initializeConverterHolder($converter_holder);

        $converter_holder
            ->registerConverter(
                'TsTzRange',
                new PgTsRange(),
                ['tstzrange'],
                false
            )
            ->registerConverter(
                'TsTzRangeArray',
                new TsTzRangeArray(),
                ['tstzrange_array'],
                false
            )
            ->registerConverter(
                'Tag3D',
                new Tag3D(),
                ['public.tag3d'],
                false
            )
            ->registerConverter(
                'Tag3DArray',
                new Tag3DArray(),
                ['public.tag3d_array'],
                false
            )
            ->registerConverter(
                'GlobalId',
                new GlobalId(),
                ['public.global_id'],
                false
            )
            ->registerConverter(
                'GlobalIdArray',
                new GlobalIdArray(),
                ['public.global_id_array'],
                false
            )
            ->registerConverter(
                'Origin',
                new Origin(),
                ['tool.origin'],
                false
            )
            ->registerConverter(
                'LQuery',
                new PgString(),
                ['lquery', 'public.lquery'],
                false
            )
            ->registerConverter(
                'LTtree',
                new PgLtree(),
                ['ltree', 'public.ltree'],
                false
            )
            ->registerConverter(
                'Link',
                new Link(),
                ['link', 'public.link'],
                false
            )
            ->registerConverter(
                'Geometry',
                new Geometry(),
                ['geometry', 'public.geometry'],
                false
            )
            ->registerConverter(
                'Address',
                new Address(),
                ['generic.address'],
                false
            )
            ->registerConverter(
                'OfficeCollection',
                new OfficeCollection(),
                ['generic.office_collection'],
                false
            )
            ->registerConverter(
                'EmptyData',
                new EmptyData(),
                ['generic.empty_data'],
                false
            )
            ->registerConverter(
                'DataWithSeo',
                new DataWithSeo(),
                ['generic.data_with_seo'],
                false
            )

            // Brand specific data

            ->registerConverter(
                'TagData',
                new TagData(),
                ['brand.tag.data'],
                false
            )
            ->registerConverter(
                'BrandEntityHasOverrideData',
                new EntityHasOverrideData(),
                ['brand.entity_has_override.data'],
                false
            )
            ->registerConverter(
                'BrandHasMovieData',
                new BrandHasMovieData(),
                ['brand.brand_has_movie.data'],
                false
            )
            ->registerConverter(
                'BrandHasPersonData',
                new BrandHasPersonData(),
                ['brand.brand_has_person.data'],
                false
            )
            ->registerConverter(
                'AuthorData',
                new AuthorData(),
                ['brand.author.data'],
                false
            )
            ->registerConverter(
                'BrandCompanyData',
                new BrandCompanyData(),
                ['brand.company.data'],
                false
            )
            ->registerConverter(
                'BrandTheaterData',
                new BrandTheaterData(),
                ['brand.theater.data'],
                false
            )

            // Theater specific data

            ->registerConverter(
                'TheaterData',
                new TheaterData(),
                ['theater.theater.data'],
                false
            )
            ->registerConverter(
                'TheaterTransportation',
                new Transportation(),
                ['theater.theater.transportation'],
                false
            )
            ->registerConverter(
                'ProductData',
                new ProductData(),
                ['country.product.data'],
                false
            )

            // Company specific data

            ->registerConverter(
                'CompanyData',
                new CompanyData(),
                ['executive.company.data'],
                false
            )
            ->registerConverter(
                'ScreenData',
                new ScreenData(),
                ['theater.screen.data'],
                false
            )

            // social specific data

            ->registerConverter(
                'SocialUserData',
                new SocialUserData(),
                ['social.user.data'],
                false
            )
            ->registerConverter(
                'SocialUserHasReviewData',
                new SocialUserHasReviewData(),
                ['social.user_has_review.data'],
                false
            )
            ->registerConverter(
                'SocialUserHasReviewStats',
                new SocialUserHasReviewStats(),
                ['social.user_has_review.stats'],
                false
            )
            ->registerConverter(
                'SocialUserHasRatingReviewData',
                new SocialUserHasRatingReviewData(),
                ['social.user_has_rating_review.data'],
                false
            )
            ->registerConverter(
                'CertificationStatusEnum',
                new CertificationStatusEnum(),
                ['social.cert_status_enum', 'cert_status_enum'],
                false
            )

            // secure specific data

            ->registerConverter(
                'SecureTokenData',
                new SecureTokenData(),
                ['secure.token.data'],
                false
            )

            // entity flag

            ->registerConverter(
                'BrandEntityFlagFlag',
                new Flag(),
                ['brand.entity_flag.flag'],
                false
            )

            // dark_zone

            ->registerConverter(
                'DarkZoneLostMatchingData',
                new DarkZoneLostMatchingData(),
                ['dark_zone.lost.matching_data'],
                false
            )

            // movie

            ->registerConverter(
                'MovieMovieHasReleaseData',
                new MovieMovieHasReleaseData(),
                ['movie.movie_has_release.data'],
                false
            )

            // series

            ->registerConverter(
                'SeriesSeriesHasReleaseData',
                new SeriesSeriesHasReleaseData(),
                ['series.series_has_release.data'],
                false
            )
            ->registerConverter(
                'SeriesSeriesSeasonHasReleaseData',
                new SeriesSeriesSeasonHasReleaseData(),
                ['series.series_season_has_release.data'],
                false
            )
            ->registerConverter(
                'SeriesSeriesEpisodeHasReleaseData',
                new SeriesSeriesEpisodeHasReleaseData(),
                ['series.series_episode_has_release.data'],
                false
            )

            // executive

            ->registerConverter(
                'ExecutiveLocaleData',
                new ExecutiveLocaleData(),
                ['executive.locale.data'],
                false
            )

        ;

        return $this;
    }
}
