<?php

namespace Allocine\DbzModelBundle\Internal\Core;

use PommProject\PommBundle\Model\ContainerModelPooler as PommContainerModelPooler;

class ContainerModelPooler extends PommContainerModelPooler
{
    private $serviceMap = [];

    public function addModelToServiceMapping($class, $serviceId)
    {
        $this->serviceMap[$serviceId] = $class;
    }

    /**
     * {@inheritdoc}
     */
    protected function createClient($class)
    {
        foreach ($this->serviceMap as $serviceId => $serviceClass) {
            if ($class == $serviceClass) {
                return $this->container->get($serviceId);
            }
        }

        return parent::createClient($class);
    }
}
