<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Theater;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Transportation as TransportationType;

class Transportation implements ConverterInterface
{
    /**
     * @param string  $data
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($data, $type, Session $session)
    {
        return new TransportationType($data);
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
