<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ArrayTypeConverter;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Domains\Tag3D as Tag3dDomain;

class Tag3D extends ArrayTypeConverter
{
    /**
     * @param string  $data
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($data, $type, Session $session)
    {
        $data = trim($data);

        if (is_null($data) || ($data === '')) {
            return null;
        }

        return new Tag3dDomain($data);
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     *
     * @return string
     */
    public function toPg($data, $type, Session $session)
    {
        if (is_null($data)) {
            return sprintf("NULL::%s", $type);
        } else {
            $data = new Tag3dDomain($data);

            return sprintf("ltree '%s'", $data->__toString());
        }
    }

    /**
     * @param mixed $data
     * @param string $type
     * @param Session $session
     *
     * @return Tag3dDomain|string
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        if (is_null($data)) {
            return null;
        } else {
           return new Tag3dDomain($data);
        }
    }
}
