<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\EmptyData as EmptyDataType;

class EmptyData implements ConverterInterface
{
    /**
     * @param string  $emptyData
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]
     */
    public function fromPg($emptyData, $type, Session $session)
    {
        return new EmptyDataType($emptyData);
    }

    /**
     * @param mixed $emptyData
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($emptyData, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($emptyData->toJson())
        );
    }

    /**
     * @param mixed $emptyData
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($emptyData, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($emptyData->toJson())
        );
    }
}
