<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\Data\DataWithSeo
    as DataWithSeoType;

class DataWithSeo implements ConverterInterface
{
    /**
     * @param string  $dataWithSeo
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]
     */
    public function fromPg($dataWithSeo, $type, Session $session)
    {
        return new DataWithSeoType($dataWithSeo);
    }

    /**
     * @param mixed $dataWithSeo
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($dataWithSeo, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($dataWithSeo->toJson())
        );
    }

    /**
     * @param mixed $dataWithSeo
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($dataWithSeo, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($dataWithSeo->toJson())
        );
    }
}
