<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Generic\Address as AddressType;

class Address implements ConverterInterface
{
    /**
     * @param string  $address
     * @param string  $type
     * @param Session $session
     *
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg($address, $type, Session $session)
    {
        return new AddressType($address);
    }

    /**
     * @param mixed $address
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPg($address, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($address->toJson())
        );
    }

    /**
     * @param mixed $address
     * @param string $type
     * @param Session $session
     * @return string
     */
    public function toPgStandardFormat($address, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($address->toJson())
        );
    }
}
