<?php

namespace Allocine\DbzModelBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * @var string
     */
    private $projectDir;

    /**
     * Configuration constructor.
     *
     * @param string $projectDir
     */
    public function __construct(string $projectDir)
    {
        $this->projectDir = $projectDir;
    }

    /**
     * getConfigTreeBuilder.
     *
     * @see ConfigurationInterface
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('dbz_model');
        $rootNode = $treeBuilder->getRootNode();
        $rootNode
            ->children()
                ->scalarNode('fixtures_path')
                    ->defaultValue($this->projectDir . DIRECTORY_SEPARATOR . 'fixtures')
                ->end()
                ->scalarNode('query_logger')->end()
                ->booleanNode('force_master_backend')
                    ->defaultFalse()
                ->end()
                ->scalarNode('sensitive_data_encryption_key')
                    ->isRequired()
                    ->info('This is the key used to decrypt sensitive data stored in dbz.')
                ->end()
                ->scalarNode('sensitive_data_encryption_algorithm')
                    ->isRequired()
                    ->info('This is the algorithm used to decrypt sensitive data stored in dbz.')
                ->end()
                ->arrayNode('backends')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('dsn')->end()
                            ->enumNode('type')
                                ->values([ServiceHelper::BACKEND_MASTER, ServiceHelper::BACKEND_SLAVE])
                                ->isRequired()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
