<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class MasterModelPass implements CompilerPassInterface
{
    /**
     * Registers slave models to the slave session.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function process(ContainerBuilder $container)
    {
        $servicesIds = $container->findTaggedServiceIds(ModelPass::SERVICE_PREFIX.'.replicated');

        $backends = $container->getExtensionConfig('dbz_model')[0]['backends'];
        $masterSessionServiceId = ModelPass::SESSION_SERVICE_PREFIX.'.'.ServiceHelper::findSessionNameByType($backends, ServiceHelper::BACKEND_MASTER);

        foreach ($servicesIds as $id => $tags) {
            $slaveModelDefinition = $container->getDefinition($id);

            $alias = ServiceHelper::generateAliasForModel(
                $slaveModelDefinition->getClass(),
                ModelPass::SERVICE_PREFIX,
                'master'
            );

            $class = $slaveModelDefinition->getClass();

            $masterDefinition = (clone $slaveModelDefinition);
            $tags = $masterDefinition->getTags();
            $tags['pomm.model'][0] = [
                'pooler' => 'dbz.pooler.model',
                'session' => $masterSessionServiceId,
            ];
            $masterDefinition->setTags($tags);
            $container->setDefinition($alias, $masterDefinition);

            // This part should not be required because it should be registerd by the Pomm ModelPass, but it does not
            // work for a reason.
            $container->register($alias, $class)
                ->setFactory([new Reference($masterSessionServiceId), 'getModel'])
                ->addArgument($class)
            ;
        }
    }
}
