<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Secure\AutoStructure\Application as ApplicationStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

/**
 * ApplicationModel.
 *
 * Model class for table application.
 *
 * @see Model
 */
class ApplicationModel extends Model
{
    use WriteQueries;
    use ModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new ApplicationStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Secure\Application';
    }

    /**
     * @param array  $fields
     * @param string $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|Application[]
     */
    public function findAll(array $fields = [], string $suffix = '')
    {
        $sql = strtr(
            "select {projection} from {relation} $suffix",
            [
                '{projection}' => $this->createProjection($fields),
                '{relation}' => $this->structure->getRelation(),
            ]
        );

        return $this->query($sql);
    }

    /**
     * @param Application $application
     * @param array $config
     *
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function enrichApplicationWithConfig(Application $application, array $config)
    {
        if (isset($config[$application->get('name')])) {
            $application->setConfig($config[$application->get('name')]);
        }
    }
}
