<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Brand\AutoStructure\TriviaHasEntity as TriviaHasEntityStructure;
use Allocine\DbzModelBundle\Model\Brand\TriviaHasEntity;

/**
 * TriviaHasEntityModel
 *
 * Model class for table trivia_has_entity.
 *
 * @see Model
 */
class TriviaHasEntityModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new TriviaHasEntityStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Brand\TriviaHasEntity';
    }
}
