<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Brand\AutoStructure\CarouselItem as CarouselItemStructure;
use Allocine\DbzModelBundle\Model\Brand\CarouselItem;

/**
 * CarouselItemModel
 *
 * Model class for table carousel_item.
 *
 * @see Model
 */
class CarouselItemModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new CarouselItemStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Brand\CarouselItem';
    }
}
