<?php

namespace Allocine\DbzModelBundle\Tests;

use Allocine\DbzModelBundle\Tests\App\TestKernel;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase as BaseWebTestCase;

class WebTestCase extends BaseWebTestCase
{
    /**
     * {@inheritdoc}
     */
    protected static function getKernelClass()
    {
        return TestKernel::class;
    }

    /**
     * {@inheritdoc}
     */
    protected static function createKernel(array $options = [])
    {
        if (null === static::$class) {
            static::$class = static::getKernelClass();
        }
        $options['test_case'] = isset($options['test_case']) ? $options['test_case'] : null;
        $env = isset($options['environment']) ? $options['environment'] : 'test'.strtolower($options['test_case']);
        $debug = isset($options['debug']) ? $options['debug'] : true;

        return new static::$class($env, $debug, $options['test_case']);
    }
}
