# Symfony services in dbz-model-bundle

## Models

All the models from the bundle are available as **private** services.

To get the list, just use `bin/console debug:container --tag=pomm.model --show-private`.

Every model services is aliased like this `<PREFIX>.<RELATION_NAME>`:

* `PREFIX` is `dbz.model` by default
* `RELATION_NAME` is the table name, ex: `secure.token`
* so we get something like `dbz.model.secure.token` as an alias for the `TokenModel` service 

The prefix eases integration in other project but can be overridden by configuration:

```
dbz_model:
    service_prefix: my_app_prefix
```

```
$ bin/console debug:container --show-private | grep my_app_prefix

  my_app_prefix.brand.entity_has_override           alias for "Allocine\DbzModelBundle\Model\Brand\EntityHasOverrideModel"
  my_app_prefix.country.entity_has_custom_data      alias for "Allocine\DbzModelBundle\Model\Country\EntityHasCustomDataModel"
  my_app_prefix.country.entity_has_override         alias for "Allocine\DbzModelBundle\Model\Country\EntityHasOverrideModel"
  my_app_prefix.executive.company                   alias for "Allocine\DbzModelBundle\Model\Executive\CompanyModel"
  my_app_prefix.executive.company_localized         alias for "Allocine\DbzModelBundle\Model\Executive\CompanyLocalizedModel"
  my_app_prefix.executive.country                   alias for "Allocine\DbzModelBundle\Model\Executive\CountryModel"
  my_app_prefix.executive.locale                    alias for "Allocine\DbzModelBundle\Model\Executive\LocaleModel"
  my_app_prefix.executive.localization              alias for "Allocine\DbzModelBundle\Model\Executive\LocalizationModel"
  my_app_prefix.media.image                         alias for "Allocine\DbzModelBundle\Model\Media\ImageModel"
  my_app_prefix.media.image_localized               alias for "Allocine\DbzModelBundle\Model\Media\ImageLocalizedModel"
  my_app_prefix.movie.movie                         alias for "Allocine\DbzModelBundle\Model\Movie\MovieModel"
  my_app_prefix.movie.movie_has_company             alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasCompanyModel"
  my_app_prefix.movie.movie_has_country             alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasCountryModel"
  my_app_prefix.movie.movie_has_global_box_office   alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasGlobalBoxOfficeModel"
  my_app_prefix.movie.movie_has_image               alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasImageModel"
  my_app_prefix.movie.movie_has_person              alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasPersonModel"
  my_app_prefix.movie.movie_has_person_localized    alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasPersonLocalizedModel"
  my_app_prefix.movie.movie_has_release             alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasReleaseModel"
  my_app_prefix.movie.movie_has_soundtrack          alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasSoundtrackModel"
  my_app_prefix.movie.movie_has_temporal_box_office alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasTemporalBoxOfficeModel"
  my_app_prefix.movie.movie_has_video               alias for "Allocine\DbzModelBundle\Model\Movie\MovieHasVideoModel"
  my_app_prefix.movie.movie_localized               alias for "Allocine\DbzModelBundle\Model\Movie\MovieLocalizedModel"
  my_app_prefix.movie.movie_version                 alias for "Allocine\DbzModelBundle\Model\Movie\MovieVersionModel"
  my_app_prefix.secure.application                  alias for "Allocine\DbzModelBundle\Model\Secure\ApplicationModel"
  my_app_prefix.secure.token                        alias for "Allocine\DbzModelBundle\Model\Secure\TokenModel"
  my_app_prefix.secure.user                         alias for "Allocine\DbzModelBundle\Model\Secure\UserModel"
```

