<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use Allocine\DbzModelBundle\Model\Secure\AutoStructure\Token as TokenStructure;

/**
 * TokenModel.
 *
 * Model class for table token.
 *
 * @see Model
 */
class TokenModel extends Model
{
    use WriteQueries;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new TokenStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Secure\Token';
    }

    /**
     * @param array $fields
     *
     * @return Projection
     */
    public function createProjection(array $fields = [])
    {
        if (empty($fields)) {
            return parent::createProjection();
        }

        $projection = parent::createProjection();
        foreach ($fields as $name => $field) {
            $projection->setField($name, ...$field);
        }
    }

    /**
     * @param array  $fields
     * @param string $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|Token[]
     */
    public function findAll(array $fields = [], string $suffix = '')
    {
        $sql = strtr(
            "select {projection} from {relation} $suffix",
            [
                '{projection}' => $this->createProjection($fields),
                '{relation}' => $this->structure->getRelation(),
            ]
        );

        return $this->query($sql);
    }
}
