<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use PommProject\ModelManager\Model\Model;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Loader\PhpFileLoader;

class ModelAliasesPass implements CompilerPassInterface
{
    /**
     * Add aliases for every model services, prefixed by parameter dbz_model.service_prefix (default: dbz.model).
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $serviceIds = $container->findTaggedServiceIds('pomm.model');

        foreach ($serviceIds as $serviceId => $serviceConfig) {
            /** @var Model $model */
            $model = new $serviceId();
            $alias = sprintf(
                '%s.%s',
                $container->getParameter('dbz_model.service_prefix'),
                $model->getStructure()->getRelation()
            );

            $container->setAlias($alias, $serviceId);
        }
    }
}
