<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserCollection as UserCollectionStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

/**
 * UserCollectionModel.
 *
 * Model class for table user_collection.
 *
 * @see Model
 */
class UserCollectionModel extends Model implements BrandAwareModelInterface
{
    use BrandAwareModelTrait;
    use WriteQueries;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserCollectionStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Social\UserCollection';
    }
}
