<?php

namespace Allocine\DbzModelBundle\Decorator\Social;

use Allocine\DbzModelBundle\Common\Social\UserModelInterface;
use Allocine\DbzModelBundle\Crypto\SensitiveDataEncryptor;
use Allocine\DbzModelBundle\Model\Social\User;
use Allocine\DbzModelBundle\Model\Social\UserModel;

/**
 * Class DecryptedUserModelDecorator
 * @package Allocine\DbzModelBundle\Decorator\Social
 * @deprecated this class will be removed, use Allocine\DbzModelBundle\Model\Social\UserModel instead
 */
class DecryptedUserModelDecorator implements UserModelInterface
{
    /**
     * @var SensitiveDataEncryptor
     */
    private $sensitiveDataEncryptor;

    /**
     * @var UserModel
     */
    private $userModel;

    /**
     * @param SensitiveDataEncryptor $sensitiveDataEncryptor
     * @param UserModel $userModel
     */
    public function __construct(SensitiveDataEncryptor $sensitiveDataEncryptor, UserModel $userModel)
    {
        $this->sensitiveDataEncryptor = $sensitiveDataEncryptor;
        $this->userModel = $userModel;
    }

    /**
     * Decorator to query database with UNCRYPTED email
     *
     * @param string $email
     * @param string $idBrand
     * @param bool   $uncrypt
     *
     * @return User|null
     */
    public function loadByEmail(string $email, string $idBrand, bool $uncrypt = false)
    {
        $cryptedEmail = $this->sensitiveDataEncryptor->encrypt($email);

        $user = $this->userModel->loadByEmail($cryptedEmail, $idBrand);

        if ($user instanceof User && $uncrypt) {
            $user = $this->uncrypt($user);
        }

        return $user;
    }

    /**
     * @param string $gid
     * @param bool $uncrypt
     *
     * @return array
     */
    public function loadByGid(string $gid, bool $uncrypt = false)
    {
        $user = $this->userModel->loadByGid($gid);

        if ($user instanceof User && $uncrypt) {
            $user = $this->uncrypt($user);
        }

        return $user;
    }

    /**
     * @param $field
     * @param $ids
     * @param array $fields
     * @return array
     */
    public function findAllWhereIn(string $field, array $ids, $fields=[])
    {
        $results = $this->userModel->findAllWhereIn($field, $ids, $fields);

        $users = [];
        foreach ($results as $user) {
            $users[] = $this->uncrypt($user);
        }

        return $users;
    }

    /**
     * @param array $user
     * @param bool $encrypt
     * @return User|null
     */
    public function createAndSave(array $user, bool $encrypt = true)
    {
        if ($encrypt) {
            $user = $this->encrypt($user);
        }

        return $this->userModel->createAndSave($user);
    }

    /**
     * @param User $user
     * @param array $fields
     * @param bool $encrypt
     */
    public function updateAndSave(User $user, array $fields, bool $encrypt = false)
    {
        if ($encrypt) {
            $user = $this->encrypt($user);
        }

        $this->userModel->updateOne($user, $fields);
    }

    /**
     * @param array|User $data
     * @return array
     */
    private function encrypt($data)
    {
        if (!empty($data['email'])) {
            $data['email'] = $this->sensitiveDataEncryptor->encrypt($data['email']);
        }

        if (!empty($data['password'])) {
            $data['password'] = $this->sensitiveDataEncryptor->encrypt($data['password']);
        }

        if (!empty($data['salt'])) {
            $data['salt'] = $this->sensitiveDataEncryptor->encrypt($data['salt']);
        }

        if (!empty($data['profile'])) {
            $data['profile'] = $this->sensitiveDataEncryptor->encrypt($data['profile'], SensitiveDataEncryptor::FIELD_TYPE_JSON_STR, function ($item) {
                return $item;
            });
        }

        return $data;
    }

    //public function findWhere()

    /**
     * @param User $user
     * @return User
     */
    public function uncrypt(User $user)
    {
        if (!empty($user['email'])) {
            $user['email'] = $this->sensitiveDataEncryptor->decrypt($user['email']);
        }

        if (!empty($user['profile'])) {
            $user['profile'] = $this->sensitiveDataEncryptor->decrypt($user['profile'], SensitiveDataEncryptor::FIELD_TYPE_JSON_STR);
        }

        return $user;
    }

    /**
     * @param string $method
     * @param array $arguments
     * @return mixed
     */
    public function __call(string $method, array $arguments)
    {
        if (!method_exists($this->userModel, $method)) {
            throw new \BadMethodCallException('Method '.$method.' not found on '.get_class($this->userModel));
        }

        return call_user_func([$this->userModel, $method], ...$arguments);
    }
}
