<?php

namespace Allocine\DbzModelBundle\Tests\Type\Social\User;

use Allocine\DbzModelBundle\Domains\Tag3D;
use Allocine\DbzModelBundle\Internal\Type\Social\User\Data;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a user data with no field

        $userData = new Data('{}');

        $this->assertNull($userData->activation);
        $this->assertNull($userData->password_reset);
        $this->assertEmpty($userData->badges);
        $this->assertEquals([], $userData->badges->getArrayCopy());

        // Create a user data

        $userData = new Data([
            'activation' => [
                'token' => 'ABC',
                'created_at' => '2000-01-01',
            ],
            'password_reset' => [
                'token' => 'DEF',
                'created_at' => '2001-01-01',
            ],
            'badges' => [
                [
                    'badge' => 'A.B.C',
                    'created_at' => '2002-01-01',
                ],
                [
                    'badge' => 'D.E.F',
                    'created_at' => '2003-01-01',
                ],
            ],

        ]);

        $this->assertEquals('ABC', $userData->activation->token);
        $this->assertEquals(
            new \DateTime('2000-01-01'),
            $userData->activation->created_at
        );
        $this->assertEquals('DEF', $userData->password_reset->token);
        $this->assertEquals(
            new \DateTime('2001-01-01'),
            $userData->password_reset->created_at
        );
        $this->assertEquals(
            new Tag3D('A.B.C'),
            $userData->badges[0]->badge
        );
        $this->assertEquals(
            new \DateTime('2002-01-01'),
            $userData->badges[0]->created_at
        );
        $this->assertEquals(
            new Tag3D('D.E.F'),
            $userData->badges[1]->badge
        );
        $this->assertEquals(
            new \DateTime('2003-01-01'),
            $userData->badges[1]->created_at
        );
    }

    public function testHasBadge()
    {
        // Create a user data with no field

        $userData = new Data('{}');

        $this->assertFalse($userData->badges->hasBadge('A.B.C'));
    }
}
