<?php

namespace Allocine\DbzModelBundle\Tests\Type\Brand\Theater;

use Allocine\DbzModelBundle\Internal\Type\Brand\Theater\Data;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a theater data with no field

        $theaterData = new Data('{}');

        $this->assertNull($theaterData->showtime_source);
        $this->assertNull($theaterData->founded_at);
        $this->assertNull($theaterData->info->email);
        $this->assertNull($theaterData->info->phone);
        $this->assertNull($theaterData->info->url);
        $this->assertNull($theaterData->info->url_showtimes);
        $this->assertNull($theaterData->info->url_showtimes_alternate);
        $this->assertNull($theaterData->info->temporary_closure);
        $this->assertNull($theaterData->executive->market);
        $this->assertFalse($theaterData->executive->has_atom_ticketing);
        $this->assertFalse($theaterData->executive->has_movietickets_ticketing);
        $this->assertNull($theaterData->links->facebook);
        $this->assertNull($theaterData->links->instagram);
        $this->assertNull($theaterData->links->linkedin);
        $this->assertNull($theaterData->links->pinterest);
        $this->assertNull($theaterData->links->snapchat);
        $this->assertNull($theaterData->links->tiktok);
        $this->assertNull($theaterData->links->tumblr);
        $this->assertNull($theaterData->links->twitter);
        $this->assertNull($theaterData->links->vk);
        $this->assertNull($theaterData->links->wechat);
        $this->assertNull($theaterData->links->youtube);
        $this->assertNull($theaterData->override->showtime_week_release_day);
        $this->assertTrue($theaterData->seo->browsable);
        $this->assertNull($theaterData->seo->title);
        $this->assertNull($theaterData->seo->alternate_title);
        $this->assertNull($theaterData->seo->description);

        // Create an object with a lot of data

        $theaterData = new Data([
            'showtime_source' => 'S1',
            'founded_at' => '1970-01-01',
            'info' => [
                'email' => 'E1',
                'phone' => 'P1',
                'url' => 'U1',
                'url_showtimes' => 'U2',
                'url_showtimes_alternate' => 'U3',
                'temporary_closure' => [
                    'starts_at' => '1971-01-01',
                    'ends_at' => '1972-01-01',
                    'message' => 'M1',
                ],
            ], 'executive' => [
                'market' => 'M2',
                'has_atom_ticketing' => false,
                'has_movietickets_ticketing' => false,
            ], 'links' => [
                'facebook' => 'L1',
                'instagram' => 'L2',
                'linkedin' => 'L3',
                'pinterest' => 'L4',
                'snapchat' => 'L5',
                'tiktok' => 'L6',
                'tumblr' => 'L7',
                'twitter' => 'L8',
                'vk' => 'L9',
                'wechat' => 'L10',
                'youtube' => 'L11',
            ], 'override' => [
                'showtime_week_release_day' => 'Monday'
            ], 'seo' => [
                'browsable' => false,
                'title' => 'T1',
                'alternate_title' => 'T2',
                'description' => 'D1',
            ],
        ]);

        $this->assertEquals('S1', $theaterData->showtime_source);
        $this->assertEquals(
            new \DateTime('1970-01-01'),
            $theaterData->founded_at
        );
        $this->assertEquals('E1', $theaterData->info->email);
        $this->assertEquals('P1', $theaterData->info->phone);
        $this->assertEquals('U1', $theaterData->info->url);
        $this->assertEquals('U2', $theaterData->info->url_showtimes);
        $this->assertEquals('U3', $theaterData->info->url_showtimes_alternate);
        $this->assertEquals(
            new \DateTime('1971-01-01'),
            $theaterData->info->temporary_closure->starts_at
        );
        $this->assertEquals(
            new \DateTime('1972-01-01'),
            $theaterData->info->temporary_closure->ends_at
        );
        $this->assertEquals(
            'M1',
            $theaterData->info->temporary_closure->message
        );
        $this->assertEquals('M2', $theaterData->executive->market);
        $this->assertEquals('L1', $theaterData->links->facebook);
        $this->assertEquals('L2', $theaterData->links->instagram);
        $this->assertEquals('L3', $theaterData->links->linkedin);
        $this->assertEquals('L4', $theaterData->links->pinterest);
        $this->assertEquals('L5', $theaterData->links->snapchat);
        $this->assertEquals('L6', $theaterData->links->tiktok);
        $this->assertEquals('L7', $theaterData->links->tumblr);
        $this->assertEquals('L8', $theaterData->links->twitter);
        $this->assertEquals('L9', $theaterData->links->vk);
        $this->assertEquals('L10', $theaterData->links->wechat);
        $this->assertEquals('L11', $theaterData->links->youtube);
        $this->assertEquals(
            'Monday',
            $theaterData->override->showtime_week_release_day
        );
        $this->assertFalse($theaterData->seo->browsable);
        $this->assertEquals('T1', $theaterData->seo->title);
        $this->assertEquals('T2', $theaterData->seo->alternate_title);
        $this->assertEquals('D1', $theaterData->seo->description);
    }
}
