<?php

namespace Allocine\DbzModelBundle\Tests\Type\Brand\Tag;

use Allocine\DbzModelBundle\Internal\Type\Brand\Tag\Data;
use Allocine\DbzModelBundle\Internal\Type\Generic\Coordinates;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testConstruct()
    {
        // Create a tag data with no field

        $tagData = new Data('{}');

        $this->assertNull($tagData->seo->scope->user_rating->movie->title);
        $this->assertNull($tagData->seo->scope->user_rating->movie->description);

        // Create a full tag data

        $tagData = new Data([
            'localization' => [
                'coordinates' => [
                    'latitude' => 1,
                    'longitude' => 2
                ],
            ],
            'seo' => [
                'browsable' => true,
                'friendly' => false,
                'top_ranking' => false,
                'scope' => [
                    'user_rating' => [
                        'movie' => [
                            'title' => 'Movie title',
                            'description' => 'Movie description',
                        ],
                        'series' => [
                            'title' => 'Series title',
                            'description' => 'Series description',
                        ],
                    ],

                ],
            ],
        ]);

        $this->assertEquals(new Coordinates([
            'latitude' => 1,
            'longitude' => 2
        ]), $tagData->localization->coordinates);

        $this->assertTrue($tagData->seo->browsable);
        $this->assertFalse($tagData->seo->friendly);
        $this->assertFalse($tagData->seo->top_ranking);
        $this->assertEquals('Movie title', $tagData->seo->scope->user_rating->movie->title);
        $this->assertEquals('Series title', $tagData->seo->scope->user_rating->series->title);
        $this->assertEquals('Movie description', $tagData->seo->scope->user_rating->movie->description);
        $this->assertEquals('Series description', $tagData->seo->scope->user_rating->series->description);

        // Create a tag with an invalid field

        $this->expectException('\Exception');
        $this->expectExceptionMessage(
            'Invalid attribute [coin] for constrained object [Allocine\DbzModelBundle\Internal\Type\Brand\Tag\Data'
        );

        new Data([
            'coin' => 'PAN'
        ]);
    }
}
