<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * BrandHasImage.
 *
 * Structure class for relation brand.brand_has_image.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class BrandHasImage extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.brand_has_image')
            ->setPrimaryKey(['id_image', 'id_brand'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'jsonb')
            ->addField('id_brand', 'bpchar')
            ->addField('id_image', 'int8')
            ->addField('title', 'text')
            ->addField('description', 'text')
        ;
    }
}
