<?php

namespace Allocine\DbzModelBundle\Internal\Type\Generic\Office;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Department extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'name' => null,
            'phone' => null,
            'employees' => []
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'employees' => new ClassDefinition([
                'class' => EmployeeCollection::class
            ]),
        ];
    }
}
