<?php

namespace Allocine\DbzModelBundle\Tests\Domain;

use Allocine\DbzModelBundle\Domains\Tag3D;
use Allocine\DbzModelBundle\Model\Tool\Origin;
use Allocine\DbzModelBundle\Crypto\SensitiveDataEncryptor;

class Tag3DTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @dataProvider getTestData
     */
    public function testGenerate(string $category, ?string $subCategory, string $tag, string $expectedTag)
    {
        $generatedTag = Tag3D::generate($category, $subCategory, $tag);


        $this->assertEquals($expectedTag, $generatedTag);
    }

    /**
     * @return string[][]
     */
    public function getTestData()
    {
        return [
            [ 'Release', 'Type', 'Platform', 'Release.Type.Platform'], // basic test
            [ 'reLEase', 'type', 'platform', 'Release.Type.Platform'], // UC First
            [ 'Release', 'Certificate', 'PG-13', 'Release.Certificate.Pg13'], // remove non letters and numbers
            [ 'Release', null, 'PG-13', 'Release._.Pg13'], // null values
        ];
    }
}
