<?php

namespace Allocine\DbzModelBundle\Tests\Domain;

use Allocine\DbzModelBundle\Domains\GlobalId;

class GlobalIdTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @dataProvider getTestData
     *
     * @param string      $schema
     * @param string      $table
     * @param null|string $brand
     * @param int         $id
     * @param string      $expectedGid
     * @param array       $expectedGidArray
     */
    public function testToString(
        string $schema,
        string $table,
        ?string $brand,
        int $id,
        string $expectedGid,
        array $expectedGidArray
    ) {
        $globalId = new GlobalId($schema, $table, $brand, $id);
        $this->assertEquals($expectedGid, (string) $globalId);
        $this->assertEquals($expectedGidArray, $globalId->toArray());
    }

    /**
     * @return string[][]
     */
    public function getTestData()
    {
        return [
            [ // basic test
                'social',
                'user_collection',
                'AC',
                '2',
                'social.user_collection.AC.2',
                ['social', 'user_collection', 'AC', '2']
            ],
            [ // remove non letters and numbers
                'social',
                'user_collection@',
                'AC',
                '2',
                'social.user_collection.AC.2',
                ['social', 'user_collection', 'AC', '2']
            ],
            [ // null values
                'movie',
                'movie',
                null,
                '3',
                'movie.movie._.3',
                ['movie', 'movie', '_', '3']
            ],
        ];
    }
}
